/* $Id: version.h,v 1.9.2.4 2002/07/17 14:21:00 gjertsen Exp $ */

/* Customized <linux/version.h> file for GPFS portability module.
   A standard header file is used here verses a patch/diff file
   because this Linux kernel file will vary depending on the
   source distribution, architectural platform, etc. */

#ifdef GPFS_ARCH_I386

# if LINUX_KERNEL_VERSION == 2040202
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.2-2smp"
#   else
#     define UTS_RELEASE "2.4.2-2"
#   endif
#   define LINUX_VERSION_CODE 132098
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040600
#   ifdef CONFIG_SMP
#     define UTS_RELEASE "2.4.6smp"
#   else
#     define UTS_RELEASE "2.4.6"
#   endif
#   define LINUX_VERSION_CODE 132102
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040312
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.3-12smp"
#   else
#     define UTS_RELEASE "2.4.3-12"
#   endif
#   define LINUX_VERSION_CODE 132099
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040710
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.7-10smp"
#   else
#     define UTS_RELEASE "2.4.7-10"
#   endif
#   define LINUX_VERSION_CODE 132103
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040907
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.9-7smp"
#   else
#     define UTS_RELEASE "2.4.9-7"
#   endif
#   define LINUX_VERSION_CODE 132105
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040912
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.9-12smp"
#   else
#     define UTS_RELEASE "2.4.9-12"
#   endif
#   define LINUX_VERSION_CODE 132105
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040913
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.9-13smp"
#   else
#     define UTS_RELEASE "2.4.9-13"
#   endif
#   define LINUX_VERSION_CODE 132105
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040921
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.9-21smp"
#   else
#     define UTS_RELEASE "2.4.9-21"
#   endif
#   define LINUX_VERSION_CODE 132105
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040931
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.9-31smp"
#   else
#     define UTS_RELEASE "2.4.9-31"
#   endif
#   define LINUX_VERSION_CODE 132105
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2040934
#   ifdef CONFIG_SMP
#     define UTS_RELEASE "2.4.9-34smp"
#   else
#     define UTS_RELEASE "2.4.9-34"
#   endif
#   define LINUX_VERSION_CODE 132105
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2041000
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.10smp"
#   else
#     define UTS_RELEASE "2.4.10"
#   endif
#   define LINUX_VERSION_CODE 132106
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2041803
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.18-3smp"
#   else
#     define UTS_RELEASE "2.4.18-3"
#   endif
#   define LINUX_VERSION_CODE 132114
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2041804
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.18-4smp"
#   else
#     define UTS_RELEASE "2.4.18-4"
#   endif
#   define LINUX_VERSION_CODE 132114
#   define __SUPPORTED_VERSION
# endif
# if LINUX_KERNEL_VERSION == 2041805
#   ifdef CONFIG_SMP   
#     define UTS_RELEASE "2.4.18-5smp"
#   else
#     define UTS_RELEASE "2.4.18-5"
#   endif
#   define LINUX_VERSION_CODE 132114
#   define __SUPPORTED_VERSION
# endif
#ifndef __SUPPORTED_VERSION
#   error Unsupported kernel version LINUX_KERNEL_VERSION
# endif

#   define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))

#endif /* GPFS_ARCH_I386 */
